export function Name() { return "AK820 MAX"; }
export function VendorId() { return 3141; }
export function ProductId() { return 32777; }
export function Size() { return [6, 15]; }
export function Type() { return 'Keyboard'; }
export function Publisher() { return "LeiShe"; }
let FpsNumber = 30
export function Fps() { return FpsNumber }
export function ControllableParameters() {
	return [
		{ "property": "shutdownColor", "group": "lighting", "label": "Shutdown Color", "min": "0", "max": "360", "type": "color", "default": "#009bde" },
		{ "property": "LightingMode", "group": "lighting", "label": "Lighting Mode", "type": "combobox", "values": ["Canvas", "Forced"], "default": "Canvas" },
		{ "property": "forcedColor", "group": "lighting", "label": "Forced Color", "min": "0", "max": "360", "type": "color", "default": "#009bde" },

	];
}

const vLedNames =
	[
		"Esc", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "F10", "F11", "F12",
		"`", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "-_", "=+", "Backspace", "Del",
		"Tab", "Q", "W", "E", "R", "T", "Y", "U", "I", "O", "P", "[", "]", "\\", "Page Up",
		"CapsLock", "A", "S", "D", "F", "G", "H", "J", "K", "L", ";", "'", "Enter", "Page Down",
		"Left Shift", "Z", "X", "C", "V", "B", "N", "M", ",", ".", "/", "Right Shift", "Up Arrow", "End",
		"Left Ctrl", "Left Win", "Left Alt", "Space", "Right Alt", "Fn", "Menu", "Right Ctrl", "Left Arrow", "Down Arrow", "Right Arrow"          //13
	];

const vLedPositions =
	[[0, 0], [0, 1], [0, 2], [0, 3], [0, 4], [0, 5], [0, 6], [0, 7], [0, 8], [0, 9], [0, 10], [0, 11], [0, 12],
	[1, 0], [1, 1], [1, 2], [1, 3], [1, 4], [1, 5], [1, 6], [1, 7], [1, 8], [1, 9], [1, 10], [1, 11], [1, 12], [1, 13], [1, 14],
	[2, 0], [2, 1], [2, 2], [2, 3], [2, 4], [2, 5], [2, 6], [2, 7], [2, 8], [2, 9], [2, 10], [2, 11], [2, 12], [2, 13], [2, 14],
	[3, 0], [3, 1], [3, 2], [3, 3], [3, 4], [3, 5], [3, 6], [3, 7], [3, 8], [3, 9], [3, 10], [3, 11], [3, 12], [3, 13],
	[4, 0], [4, 1], [4, 2], [4, 3], [4, 4], [4, 5], [4, 6], [4, 7], [4, 8], [4, 9], [4, 10], [4, 11], [4, 12], [4, 13],
	[5, 0], [5, 1], [5, 2], [5, 3], [5, 4], [5, 5], [5, 6], [5, 7], [5, 8], [5, 9], [5, 10]
	];

const vKeymap =
	[
		
		 1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13,
		19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 103,		119,
		37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 67,			118,
		55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 85,				121,
		73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84,		101,		120,
		91, 92, 93,		94,			95, 96, 98, 		99,100,102,
		
	];

export function LedNames() {
	return vLedNames;
}

export function LedPositions() {
	return vLedPositions;
}

export function Initialize() {

}
export function Render() {
	sendcolor();
}
export function Shutdown() {
	// StartPacket();
	sendcolor(true);
	endPacket();
}

function StartPacket() {
	device.send_report([0x04, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08], 64);
}
function endPacket() {
	device.send_report([0x04, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00], 64);
}
let timerNew = null
function sendcolor(shutdown = false) {
	clearTimeout(timerNew) 

	endPacket();
	StartPacket();
	let packet = [];
	for (let i = 0; i < vLedPositions.length; i++) {
		packet.push(vKeymap[i]);
		packet.push(device.color(vLedPositions[i][0],vLedPositions[i][1]));
	}
	packet = packet.flat(2);
	// for (let i = 0; i < packet.length; i += 64) {
	// 	device.send_report(packet.slice(i, i + 64), 64);
	// }


	// console.log(packet.length);
	timerNew = setTimeout(() => {
		// 因为后端需要接收8个整包
		try {
			let wholePackage = Math.floor(packet.length / 64); //数据分了多少个整包(一个包64个数据)
			let remainingPackage = packet.length % 64; //数据分完整包以后剩余的余包多少个
			let packetNew  = packet //存放处理之后的数据
			let supplementPackage = 0
			if(wholePackage >8 || (wholePackage == 8 && remainingPackage >0) ){
				// 数据总数大于8个包的数据 
				// 截取前512个元素(一个包64个数据，8个包一共512个数据)
				packetNew = packet.slice(0, 512);
			}else if(wholePackage < 8){
				// 当数据少于8个包，我们需要补包
				supplementPackage =  8 - wholePackage // 用8个包减去多少个整包，就是我们需要补发多少个包
				if(remainingPackage >0){
					// 需要判断有没有余数，如果有，余数也是会单独占一个包
				  supplementPackage  = supplementPackage - 1
				}
			}
	
			for (let i = 0; i < packetNew.length; i += 4) {
				if(packetNew[i] == undefined || packetNew[i] == null){
					// console.log('heijue----0000',packetNew[i])
					packetNew[i] = 0
					packetNew[i + 1] = 0
					packetNew[i +2] = 0
					packetNew[i + 3] = 0
				}
			}
	
		  for (let i = 0; i < packetNew.length; i += 64) {
			device.send_report(packetNew.slice(i, i + 64), 64);
		  }
		  if(supplementPackage >0){
			for (let i = 0; i < supplementPackage; i++) {
				device.send_report([], 64);
			  }
		  }
			
		} catch (error) {
			
		}

	// }, 20);
	}, 1000 / (FpsNumber + 30));
	
}

function hexToRgb(hex) {
	const result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
	const colors = [];
	colors[0] = parseInt(result[1], 16);
	colors[1] = parseInt(result[2], 16);
	colors[2] = parseInt(result[3], 16);

	return colors;
}

export function Validate() {
	return { type: 0, usage: 0x0001, usagePage: 65299 };
}

export function ImageUrl() {
	return "https://assets.signalrgb.com/devices/brands/hyperx/keyboards/alloy-elite-2.png";
}